#pragma once
#include <map>
#include <string>
#include <windows.h>
#include <vector>
#include <atlstr.h>
#include <chrono>

struct StPosition {
	/// <summary>
	/// Switch value. Default value is INT_MIN.
	/// </summary>
	int S = INT_MIN;
	/// <summary>
	/// X coordinate. Default value is INT_MIN.
	/// </summary>
	int X = INT_MIN;
	/// <summary>
	/// Y coordinate. Default value is INT_MIN.
	/// </summary>
	int Y = INT_MIN;
	/// <summary>
	/// Z coordinate. Default value is INT_MIN.
	/// </summary>
	int Z = INT_MIN;
};

typedef void (*type_myCallBack) (StPosition);

class CSerialCommHelper
{
private:
	HANDLE	m_hCommPort;
	HANDLE	m_hThreadTerm;
	HANDLE	m_hThread;
	HANDLE	m_hThreadStarted;
	HANDLE	m_hDataRx;
	bool	m_abIsConnected;
	bool    m_streamingDataStarted;
	void	InvalidateHandle(HANDLE& hHandle);
	void	CloseAndCleanHandle(HANDLE& hHandle);
	void	SetPosition(char* arr);

	type_myCallBack dCallback;
	bool quit = false;
public:
	using String = std::string;
	using CNamesArray = std::vector<String>;
	CNamesArray ports;
	CSerialCommHelper();
	virtual ~CSerialCommHelper();
	HANDLE	GetWaitForEvent() { return m_hDataRx; }

	inline bool		IsConnection() { return m_abIsConnected; }
	inline void		SetDataReadEvent() { SetEvent(m_hDataRx); }

	int	Read(char* inbuff, int inbuflen);
	int	Write(char* outbuff, int outbuflen);


	HRESULT			Init(const char* szPortName = "COM1", DWORD dwBaudRate = 9600, BYTE byParity = 0, BYTE byStopBits = 1, BYTE byByteSize = 8);
	HRESULT			Start();
	HRESULT			Stop();
	HRESULT			UnInit();

	static unsigned __stdcall ThreadFn(void* pvParam);
	void setDCallback(type_myCallBack cB);
	bool detectPort();
	int init_IMMC();
	void print_hex(std::string);
	int get_int(int a, int b);
};